/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.Address;
import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.provider.BoundedMemoryIO;
import com.kenai.jaffl.provider.ShareMemoryIO;

public abstract class AbstractMemoryIO
extends MemoryIO {
    protected static final void checkBounds(long l, long l2, long l3) {
        if ((l2 | l3 | l2 + l3 | l - (l2 + l3)) < 0L) {
            throw new IndexOutOfBoundsException();
        }
    }

    public int indexOf(long l, byte by) {
        return this.indexOf(l, by, Integer.MAX_VALUE);
    }

    public long getAddress(long l) {
        return AddressIO.INSTANCE.getAddress(this, l);
    }

    public void putAddress(long l, long l2) {
        AddressIO.INSTANCE.putAddress(this, l, l2);
    }

    public void putAddress(long l, Address address) {
        AddressIO.INSTANCE.putAddress(this, l, address.longValue());
    }

    public final long getNativeLong(long l) {
        return NativeLongIO.INSTANCE.getLong(this, l);
    }

    public MemoryIO slice(long l) {
        return new ShareMemoryIO(this, l);
    }

    public MemoryIO slice(long l, long l2) {
        return new BoundedMemoryIO(this, l, l2);
    }

    public void putNativeLong(long l, long l2) {
        NativeLongIO.INSTANCE.putLong(this, l, l2);
    }

    public void transferTo(long l, MemoryIO memoryIO, long l2, long l3) {
        for (long i = 0L; i < l3; ++i) {
            memoryIO.putByte(l2 + i, this.getByte(l + i));
        }
    }

    public void transferFrom(long l, MemoryIO memoryIO, long l2, long l3) {
        for (long i = 0L; i < l3; ++i) {
            this.putByte(l + i, memoryIO.getByte(l2 + i));
        }
    }

    private static interface AddressIO {
        public static final AddressIO INSTANCE = Platform.getPlatform().addressSize() == 32 ? AddressIO32._INSTANCE : AddressIO64._INSTANCE;

        public long getAddress(MemoryIO var1, long var2);

        public void putAddress(MemoryIO var1, long var2, long var4);

        public static class AddressIO32
        implements AddressIO {
            public static final AddressIO _INSTANCE = new AddressIO32();

            public long getAddress(MemoryIO memoryIO, long l) {
                return memoryIO.getInt(l);
            }

            public void putAddress(MemoryIO memoryIO, long l, long l2) {
                memoryIO.putInt(l, (int)l2);
            }
        }

        public static class AddressIO64
        implements AddressIO {
            public static final AddressIO _INSTANCE = new AddressIO64();

            public long getAddress(MemoryIO memoryIO, long l) {
                return memoryIO.getLong(l);
            }

            public void putAddress(MemoryIO memoryIO, long l, long l2) {
                memoryIO.putLong(l, l2);
            }
        }
    }

    private static interface NativeLongIO {
        public static final NativeLongIO INSTANCE = Platform.getPlatform().longSize() == 32 ? LongIO32._INSTANCE : LongIO64._INSTANCE;

        public long getLong(MemoryIO var1, long var2);

        public void putLong(MemoryIO var1, long var2, long var4);

        public static class LongIO32
        implements NativeLongIO {
            public static final NativeLongIO _INSTANCE = new LongIO32();

            public long getLong(MemoryIO memoryIO, long l) {
                return memoryIO.getInt(l);
            }

            public void putLong(MemoryIO memoryIO, long l, long l2) {
                memoryIO.putInt(l, (int)l2);
            }
        }

        public static class LongIO64
        implements NativeLongIO {
            public static final NativeLongIO _INSTANCE = new LongIO64();

            public long getLong(MemoryIO memoryIO, long l) {
                return memoryIO.getLong(l);
            }

            public void putLong(MemoryIO memoryIO, long l, long l2) {
                memoryIO.putLong(l, l2);
            }
        }
    }
}

